local assets =
{
	Asset("ANIM", "anim/knighthelmet.zip"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "knighthelmet", "helmet")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAIR")
        end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
    --[[
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
    end
    ]]
    inst:AddTag("hat")

    anim:SetBank("knighthelmet")
    anim:SetBuild("knighthelmet")
	anim:PlayAnimation("anim")   
	
	inst:AddComponent("armor")
	inst.components.armor:InitCondition(TUNING.ARMOR_RUINSHAT*.5, .70)
   
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/knighthelmet.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	
	local ARMORSLOW = 0.9

	if IsDLCEnabled(CAPY_DLC) then
		ARMORSLOW = -0.1
	end
	inst.components.equippable.walkspeedmult = ARMORSLOW
	
        inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
    return inst
end





return Prefab( "common/inventory/knighthelmet", fn, assets ) 
